﻿using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Configuration;
using System.Linq;
using System.Windows;
using System.Windows.Controls;

namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for AppSettings.xaml
    /// </summary>
    public partial class AppSettings : Page
    {
        private ObservableCollection<ConnectionItem> _connectionitems = new ObservableCollection<ConnectionItem>();
        private static ObservableCollection<ConnectionItem> _InitialItems = new ObservableCollection<ConnectionItem>();

        public AppSettings()
        {
            InitializeComponent();
            LoadAppSettings();
        }

        private void LoadAppSettings()
        {
            try
            {
                var appSettings = ConfigurationManager.AppSettings;

                if (appSettings.Count == 0)
                {
                    App.ShowErrorMessageBox("No app settings value found", "Ei8ht POS");
                }
                else
                {
                    var listitems = (from a in appSettings.AllKeys.ToList()
                                              select new ConnectionItem() { Key = a, Value = appSettings[a].ToString() }).ToList();
                    _connectionitems = Change<ConnectionItem>(listitems);
                    gvAppSettings.ItemsSource = _connectionitems;
                   
                }
            }
            catch (ConfigurationErrorsException)
            {
               App.ShowErrorMessageBox("Error reading app settings","Ei8ht POS");
            }
        }

        private ObservableCollection<T> Change<T>(List<T> source)
        {
            ObservableCollection<T> oc = new ObservableCollection<T>(source);
            return oc;
        }

        private void SaveAppSettings(string key,string value)
        {
            try
            {
                var configFile = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
                var settings = configFile.AppSettings.Settings;
                if (settings[key] == null)
                {
                    settings.Add(key, value);
                }
                else
                {
                    settings[key].Value = value;
                }
                configFile.Save(ConfigurationSaveMode.Modified);
                ConfigurationManager.RefreshSection(configFile.AppSettings.SectionInformation.Name);
            }
            catch (ConfigurationErrorsException)
            {
               App.ShowErrorMessageBox("Error writing app settings","Ei8ht POS");
            }
        }

        private void Button_Click_1(object sender, RoutedEventArgs e)
        {
            try
            {
                var FinalValue = gvAppSettings.ItemsSource as ObservableCollection<ConnectionItem>;
                var appSettings = ConfigurationManager.AppSettings;
                foreach (var i in FinalValue)
                {
                    if (i.Value != appSettings[i.Key].ToString())
                    {
                        SaveAppSettings(i.Key, i.Value);
                    }
                }
                MessageBox.Show("Updated successfully!");
            }
            catch
            {
                App.ShowErrorMessageBox("Error in updating App Settings Value", "Ei8htPOS");
            }
        }
    }

    public class ConnectionItem : INotifyPropertyChanged
    {
        private string _key;
        private string _value;

        public string Key
        {
            get { return _key; }
            set { _key = value; NotifyPropertyChanged("Key"); }
        }

        public string Value
        {
            get { return _value; }
            set { _value = value; NotifyPropertyChanged("Value"); }
        }

        public event PropertyChangedEventHandler PropertyChanged;
        /// <summary>
        /// Notifies the property changed.
        /// </summary>
        /// <param name="property">The info.</param>
        public void NotifyPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
    }

    
}
